/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.item.util;

import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum EEArmorMaterial implements ArmorMaterial
{
    IMMORTAL_MATERIAL("immortal", 15, (EnumMap)Util.m_137469_(new EnumMap<EquipmentSlot, V>(EquipmentSlot.class), map -> {
        map.put(EquipmentSlot.FEET, 2);
        map.put(EquipmentSlot.LEGS, 5);
        map.put(EquipmentSlot.CHEST, 6);
        map.put(EquipmentSlot.HEAD, 2);
    }), 15, SoundEvents.f_11677_, 1.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.IMMORTAL_INGOT.get()}));

    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<EquipmentSlot, Integer> protectionFunctionForType;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairMaterial;
    private static final EnumMap<EquipmentSlot, Integer> HEALTH_FUNCTION_FOR_TYPE;

    private EEArmorMaterial(String name, int durabilityMultiplier, EnumMap<EquipmentSlot, Integer> protectionFunctionForType, int enchantability, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionFunctionForType = protectionFunctionForType;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = new LazyLoadedValue(repairMaterial);
    }

    public int m_7366_(EquipmentSlot type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7365_(EquipmentSlot type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.m_13971_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(EquipmentSlot.class), map -> {
            map.put(EquipmentSlot.FEET, 13);
            map.put(EquipmentSlot.LEGS, 15);
            map.put(EquipmentSlot.CHEST, 16);
            map.put(EquipmentSlot.HEAD, 11);
        });
    }
}

